<?php

/**
 * DuoLamPHP FrameWork 
 * http://www.imoi.cn
 *
 * Copyright (c) 2011 Mo Yi
 * 
 * @author Mo Yi root@imoi.cn
 */

!defined('DL_Root') && exit ( 'Access Denied!' );
 
class DController extends DuoLamBase{

	/**
	 * 控制器文件
	 * @var string
	 */
	private $_conFile;

	 /**
	  * 参数
	  * @var array
	  */
	private $_uri = array();

	 /**
	  * 控制器类
	  * @var string
	  */
	private $_conClass;

	/**
	 * 控制器下级目录
	 * @var string
	 */
	private $_conDir=null;
	
	/**
	 * 请求的Action
	 * @var string
	 */
	private $_conFun;

	/*
	 * URL
	 */
	private $_url;
	
	/**
	 * 构造
	 */
	public function __construct()
	{
		$this->_parseUri();
	}

	/**
	 * 解析URL
	 * @access private 
	 */
	
	private function _parseUri()
	{
		$this->_url = DuoLam::url();
		if($this->_url == '/') $temp = $_SERVER['REQUEST_URI']; else $temp = substr($_SERVER['REQUEST_URI'],strlen($this->_url)-1);
		$param = $_SERVER['REQUEST_URI'] ? $temp : null;
		$htaccess = APP_PATH . '.htaccess';
		if(DuoLam::$config['frame']['mode']==1)
		{
			is_file($htaccess) && unlink($htaccess);
			$param = substr($param,5);
		}
		else
		{	
			is_file($htaccess) or DEr::notice('没有.htaccess文件');
		}
		
		$paramOne = explode('/',$param);
		$paramTwo = explode(duoLam::$config['default']['getSign'],empty($paramOne[3]) ? null : $paramOne[3]);
		
		if(stripos(empty($paramOne[1]) ? '' : $paramOne[1] , '-') !== false)
		{
			$tempstr = explode('-',$paramOne[1]);
			$this->_conDir = $tempstr[0] . DS;
			$paramOne[1] = $tempstr[1];
		}
		
		$this->_conClass = empty($paramOne[1]) ? 'Action'.DuoLam::$config['default']['con'] : 'Action'.ucfirst($paramOne[1]);
		$this->_conFun = empty($paramOne[2]) ? DuoLam::$config['default']['fun'] : $paramOne[2];
		define('C',empty($paramOne[1]) ? DuoLam::$config['default']['con'] : $paramOne[1]);
		define('A',empty($paramOne[2]) ? DuoLam::$config['default']['fun'] : $paramOne[2]);
		unset($paramOne);$this->_uri = $paramTwo;
		$this->_setGet();
		$this->_checkClass();
	}
	
	/**
	 * 组合$_GET参数
	 */
	private function _setGet()
	{
		if(!empty($this->_uri))
		{
			if(DuoLam::$config['frame']['html_on'])
			{
				$key = count($this->_uri)-1;
				$value = $this->_uri[$key];
				if(stripos($value,'.') !==false)
				{
					$temp = explode('.',$value);
					if($temp[1] != DuoLam::$config['frame']['html']) DEr::e404('该页面不存在！');
					$this->_uri[$key] = $temp[0];
				}
			}
			if(!DuoLam::$config['frame']['setget'])
			{
				foreach($this->_uri as $k => $v)
				{
						if(empty($v)) continue;
						if($k % 2 !== 0) $_GET[$v] = !empty($this->_uri[($k+1)]) ? $this->_uri[($k+1)] : null;
				}
			}
			else
			{
				$_GET = array_merge($_GET,$this->_uri);
			}
		}
	}

	/**
	 * 检查action
	 * @return void
	 */

	private function _checkClass()
	{
		if(stripos($this->_conClass,'@') !== false)
		{
			$classfile = explode('@',$this->_conClass);
			$S = ucfirst($classfile[1]);
			$sfile = 'ShareController'.$S;
			$path = APP_PATH . 'Controllers' . DS . 'ShareController' . DS . $sfile .'.php';
			if(is_file($path)) include_once $path;
			else DEr::notice('共享控制器文件不存在：'. $sfile .'.php');
			class_exists($sfile) or DEr::notice("共享控制器<span style='color:red;'> $sfile </span>类没有定义！");
			get_parent_class($sfile) != 'DAction' && DEr::notice("共享控制器继承错误！：$sfile");
			$this->_conClass = $classfile[0];
		}
		$this->_conFile = APP_PATH . 'Controllers' . DS . $this->_conDir . $this->_conClass . '.php';
		is_file($this->_conFile) or DEr::e404('控制器文件不存在！');
		include_once $this->_conFile;
		class_exists($this->_conClass) or DEr::e404('控制器类没有定义！');
		$methods = get_class_methods($this->_conClass);
		$fun = in_array($this->_conFun, $methods, true) ? $this->_conFun : DEr::e404('Action没有定义');
		$init = in_array('init',$methods, true) ? 'init' : null;
		$Action = new $this->_conClass();
		if(empty($init))
		{
			$Action -> setGetValueSys();
			$Action -> setget();
		}
		else
		{
			$Action -> setGetValueSys();
			$Action -> $init();
		}
		$Action -> $fun();
	}
}
?>